package com.ht.bo;

import java.util.ArrayList;
import java.util.List;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ht.dao.KanglaEbookDAO;
import com.ht.util.ConnectionUtil;
import com.ht.vo.Catalog;
import com.ht.vo.Product;

public class KanglaEbookBO {
	Bucket theBucket;
	KanglaEbookDAO client = new KanglaEbookDAO();
	
	public KanglaEbookBO() {
		super();
		init();
		
	}

	public void storeProduct() {
	
		 try {
			 List<Product> prodList = ConnectionUtil.populateProduct();
			 for (Product product : prodList) {
				 client.createProduct(theBucket, ConnectionUtil.getProductID(theBucket),product);
			}
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}
	
	public void createOrder(List<Product> bookList,String userId,String deliveryInstruction) {
		
		 try {
				 client.createOrder(theBucket, bookList, userId, deliveryInstruction);
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	
	public Catalog findAllCatalog() {
		Catalog catalogList = null;
		 try {
			JsonDocument doc = (JsonDocument)client.findDocumentByID(theBucket,ConnectionUtil.getCatalogID());
			Gson gson = new GsonBuilder().create();
		    catalogList =	gson.fromJson(doc.content().toString(), Catalog.class);
		   
		    /*System.out.println(catalogList.getName());
		    for ( Catalog catalog: catalogList.getSubCategory()) {
		    	System.out.println("--"+catalog.getName());
		     
		    	if(catalog.getSubCategory()!=null)
		    	for ( Catalog cataloga: catalog.getSubCategory()) {
			    	System.out.println("----"+cataloga.getName());
			    	if(cataloga.getSubCategory()!=null)
			    	for ( Catalog catalogb: cataloga.getSubCategory()) {
				    	System.out.println("------"+catalogb.getName());
				    	
					}	
				}
			}*/
			 
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
      return catalogList;
	}
	
	
	public List<Product> findAllBooksBySubCatalog(String subCatalog) {
		List<Product> docList = null;
		 try {
			 JsonDocument doc = (JsonDocument)client.findDocumentByID(theBucket,subCatalog);
			System.out.println(">>>>>" + subCatalog + doc.content().getArray("bookList").size());
			docList = client.findMultipleProducts(theBucket, doc.content().getArray("bookList"));
		 } catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
		}
		 return docList;
	}
	
	public void assignCategoryToBook() {
		
		 try {
			    ArrayList<String> books = new ArrayList<String>();
			    books.add("product::book::0");
			    books.add("product::book::1");
			    books.add("product::book::2");
			    JsonObject jObject = JsonObject.create();
			    jObject.put("bookList", books);
			    JsonDocument myDoc = JsonDocument.create("product::Programming::productList", jObject);
			    theBucket.insert(myDoc);
			   	System.out.println("------"+myDoc);
		 } catch (Exception e) {
				 
				e.printStackTrace();
			}
	}
	
	
	public void init() {

		try {
			theBucket = ConnectionUtil.getTheBucket();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
}
